clear all

* Set Folder to output one

cd ..\Outputs

* Call and merge databases

use fig14COC, clear

joinby year quarter using fig14PCU, unmatched(both)
drop _merge
joinby year quarter using fig14GAL, unmatched(both)
drop _merge
joinby year quarter using fig14BQA, unmatched(both)
drop _merge

local from = 2004
local to   = 2017

twoway ///
(line fig14PCU2 time if year>=`from' & year<=`to', lcolor(green) lpattern(dash_dot)) ///
(line fig14BQA6 time if year>=`from' & year<=`to', lcolor(blue) lpattern(dash)) ///
(line fig14GAL6 time if year>=`from' & year<=`to', lcolor(red) lpattern(shortdash)) ///
(line fig14COC6 time if year>=`from' & year<=`to', lcolor(gold) lpattern(shortdash_dot)) ///
(line fig14CBO  time if year>=`from' & year<=`to', lcolor(purple) lpattern(longdash)) ///
(line fig14ACT  time if year>=`from' & year<=`to', lcolor(black) lwidth(thick)) ///
(line fig14BQA1  time if year>=`from' & year<=`to', lcolor(cyan)) ///	
, ///
xlabel(`from'(2)`to') xtitle("Year") ///
ylabel(-0.1(0.05)0.3) ytitle("log deviation from 2007Q1") ///
legend(	label(1 "Phillips") label(2 "Blanchard") ///
		label(3 "Gali") label(4 "Cochrane") label(5 "CBO") ///
		label(6 "Actual") label(7 "Pre-crisis est.") ///
		ring(0) position(11) rows(4)) ///
graphregion(color(white)) bgcolor(white)

gen PCU=(fig14PCU2-fig14ACT)*100
gen BQA=(fig14BQA6-fig14ACT)*100
gen GAL=(fig14GAL6-fig14ACT)*100
gen COC=(fig14COC6-fig14ACT)*100
gen CBO=(fig14CBO -fig14ACT)*100

drop if year>=2017

graph bar (last) GAL COC BQA PCU CBO, ///
legend(	label(1 "Gali") label(2 "Cochrane") ///
		label(3 "Blanchard") label(4 "Phillips") label(5 "CBO") ///
		rows(2)) ///
ytitle("Outut Gap in Percent") ///
bargap(50) ///
title("Remaining Output Gap in 2016 Q4") ///
graphregion(color(white)) bgcolor(white)

